var d = $(document);

$(function(){$('div.win').hide();});

function start()
{
  $('div.shadow').fadeOut(500);
  changePlayer();
  $('td').html('').removeClass('winner').removeClass('r');
}

function end()
{
  d.data('player', '');
  $('div.in-bulb').animate({left: '78px'}, 400);
  setTimeout('closeWin()', 5000);
}

function closeWin()
{
  $('div.win').fadeOut(500);
  $('div.shadow').fadeIn(500);
}

function player()
{
  return d.data('player');
}

function changePlayer()
{
  if(player() == 1)
  {
    d.data('player', '2');
    $('div.in-bulb').animate({left: '147px'}, 400);
  }
  else
  {
    d.data('player', '1');
    $('div.in-bulb').animate({left: '10px'}, 400);
  }
}

function engine()
{
  var tieUp = true;
  $('td').each(function(){
    if(!$(this).hasClass('r'))
        tieUp = false;
  });

  if(tieUp)
  {
    $('div.win > div').html('!<br/> . :)').parent().fadeIn(500);
    end();
  }

  var matrix = new Array(
    new Array('1;1', '1;2', '1;3'), new Array('2;1', '2;2', '2;3'),
    new Array('3;1', '3;2', '3;3'), new Array('1;1', '2;1', '3;1'),
    new Array('1;2', '2;2', '3;2'), new Array('1;3', '2;3', '3;3'),
    new Array('1;1', '2;2', '3;3'), new Array('1;3', '2;2', '3;1')
  );

  var ai, co, cls, win, r, c;
  for(var i = 0; i < matrix.length; i++)
  {
    ai = matrix[i];
    cls = false;
    win = new Array();
    for(var j = 0; j < 3; j++)
    {
        co = ai[j].split(';');
        e = $('tr[p=' + co[0] + '] td[p=' + co[1] + '] div');
        r = e.parent().parent().attr('p');
        c = e.parent().attr('p');

        if(!cls)
            cls = e.attr('class');
        if(!e.hasClass(cls))
            win = new Array();
        else
            win.push(r + ';' + c);
    }
    if(win.length == 3)
    {
        if(cls == 'c')
            winner = '';
        else
            winner = '';
        for(var k = 0; k < 3; k++)
        {
            co = win[k].split(';');
            $('tr[p=' + co[0] + '] td[p=' + co[1] + ']').addClass('winner');
        }
        $('div.win > div').html('!<br/>' + winner + ' .').parent().fadeIn(500);
        end();
        break;
    }
  }
}

$('input.start').live('click', function(){start();});

$('td').live('hover', function(){
  if(!$(this).text().length)
    $(this).toggleClass('hover');
});

$('td').live('click', function(){
  var e = $(this);
  var r = $(this).parent().attr('p');
  var c = $(this).attr('p');
  if(!e.children('div').length)
  {
    var res = '<div class="c">X</div>';
    if(player() == 2)
        res = '<div class="z">O</div>';
    e.html(res);
    changePlayer();
    e.removeClass('hover').addClass('r');
    engine();
  }
});